const mongoose = require("mongoose");

const wishlistSchema = new mongoose.Schema(
  {
    user: {
      type: mongoose.Schema.ObjectId,
      ref: "User",
      required: [true, "Wishlist must belong to a user"],
      unique: true,
    },
    items: [
      {
        course: {
          type: mongoose.Schema.ObjectId,
          ref: "Course",
          required: true,
        },
        // 🚀 SNAPSHOT DATA
        name: String,
        coverImage: String,
        price: Number,
        instructorName: String,
      },
    ],
  },
  { timestamps: true }
);

const Wishlist = mongoose.model("Wishlist", wishlistSchema);
module.exports = Wishlist;
